/******************************************************************************
FastExternals Plug-in Interface Header

Copyright John Paul Chacha. All Rights Reserved.

This source code file, which has been provided by John Paul Chacha as part of 
his software product for use only by licensed users of that product, includes 
proprietary information of John Paul Chacha.

USE OF THIS SOFTWARE IS GOVERNED BY THE TERMS AND CONDITIONS OF THE LICENSE 
AGREEMENT FURNISHED WITH THE PRODUCT.

IN PARTICULAR, JOHN PAUL CHACHA SHALL BE FREE FROM ANY CLAIMS OR LIABILITIES 
ARISING OUT OF THE USE OR MISUSE OF THIS FILE AND/OR ITS CONTENTS.
******************************************************************************/

#pragma once

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////


/******************************************************************************
Global Defines
******************************************************************************/
#define PLUGIN_INTERFACE_VERSION			  ((3<<16)+15)
#define PLUGIN_INTERFACE_VERSION$			   L"3 rev 15"

#define PLUGIN_APITYPE_INVALID					0x00000000
#define PLUGIN_APITYPE_FILE						0x00000001
#define PLUGIN_APITYPE_DEVICE					0x00000002
#define PLUGIN_APITYPE_EFFECT					0x00000004
#define PLUGIN_APITYPE_ENGINE					0x00000100

#define PLUGIN_IMGTYPE_LAYERED						0x0000
#define PLUGIN_IMGTYPE_IMAGELIST					0x0001
#define PLUGIN_IMGTYPE_ANIMATION					0x0002

#define PLUGIN_IMGSUBTYPE_NORMAL				    0x0000
#define PLUGIN_IMGSUBTYPE_CLIPPED				    0x0001
#define PLUGIN_IMGSUBTYPE_MULTIRES				    0x0001
#define PLUGIN_IMGSUBTYPE_ONIONSKIN					0x0001

//-----------------------------------------------------------------------------
#define PLUGIN_OKAY							     1 //success

#define PLUGIN_ERR_FAILED					     0 //general failure
#define PLUGIN_ERR_NO_SUPPORT				    -1 //not supported
#define PLUGIN_ERR_INTERNAL 				    -2 //internal error
#define PLUGIN_ERR_OUT_OF_MEM				    -3 //out of memory
#define PLUGIN_ERR_DEVICE					    -7 //device error
#define PLUGIN_ERR_BAD_HOST					   -10 //host invalid
#define PLUGIN_ERR_BAD_PARAM				   -11 //host parameter invalid
#define PLUGIN_ERR_BAD_IMAGE				   -12 //invalid image
#define PLUGIN_ERR_NOT_FLAT					   -13 //image has layers
#define PLUGIN_ERR_BAD_MODE					   -14 //unsupported image mode
#define PLUGIN_ERR_FILE_OPEN_R				   -20 //cannot open for read
#define PLUGIN_ERR_FILE_OPEN_W				   -21 //cannot open for write
#define PLUGIN_ERR_FILE_READ				   -22 //error reading data
#define PLUGIN_ERR_FILE_WRITE				   -23 //error writing data
#define PLUGIN_ERR_FILE_CORRUPT				   -31 //invalid data in file
#define PLUGIN_ERR_USER_CANCEL				   -99 //cancelled by the user

#define PLUGIN_ERROR_HINT_SIZE					1024

//-----------------------------------------------------------------------------
#define PLG_DIALOG_ABOUT						0x00000000
#define PLG_DIALOG_CONFIG						0x00000001
#define PLG_DIALOG_HELP 						0x00000002

#define PLG_FLT_XFORM_ROTATE_090				0x00000001
#define PLG_FLT_XFORM_ROTATE_180				0x00000002
#define PLG_FLT_XFORM_ROTATE_270				0x00000003
#define PLG_FLT_XFORM_FLIP_H					0x00000004
#define PLG_FLT_XFORM_FLIP_V					0x00000005
#define PLG_FLT_XFORM_TRANSPOSE					0x00000006
#define PLG_FLT_XFORM_TRANSVERSE				0x00000007

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////



/******************************************************************************
Helper Macros
******************************************************************************/

//Macro for inter-converting pixels between ARGB and ABGR
#define plg_swap_rgb(c) \
	((c&0xff00ff00)|((c>>16)&0x000000ff)|((c<<16)&0x00ff0000))

//Macro for restricting a value to within given boundaries
#define plg_limit_value(a,lo,hi) \
	{ if((a)<(lo)){a=(lo);} else if((a)>(hi)){a=(hi);} }

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////


/******************************************************************************
Basic PI Interface Structs
******************************************************************************/

//-----------------------------------------------------------------------------
//pi_StateStore
//-----------------------------------------------------------------------------
#define PI_STATESTORE_VERSION					0x00020001

struct pi_STATESTORE
{
	unsigned long version;
	unsigned long unused_1;
	int (__cdecl* temp_read )(wchar_t* name,void* data,int size);
	int (__cdecl* temp_write)(wchar_t* name,void* data,int size);
	int (__cdecl* temp_size )(wchar_t* name);
	int (__cdecl* perm_read )(wchar_t* name,void* data,int size);
	int (__cdecl* perm_write)(wchar_t* name,void* data,int size);
	int (__cdecl* perm_size )(wchar_t* name);
//32
	unsigned char	reserved_x[1024-32];//do not touch
};


//-----------------------------------------------------------------------------
//pi_BasicQuery
//-----------------------------------------------------------------------------
#define PI_BASICQUERY_VERSION					0x00000001

struct pi_BASICQUERY
{
	unsigned long version;
	unsigned long unused_1;
	void* (__cdecl* query_PI)(wchar_t* name);
	int   (__cdecl* query_data)(wchar_t* name,void* data,int size);
//16
	unsigned char	reserved_x[1024-16];//do not touch
};


//-----------------------------------------------------------------------------
//pi_BasicImage
//-----------------------------------------------------------------------------
#define PI_BASICIMAGE_VERSION					0x00010005

struct pibi_IMAGE
{
	unsigned long width;
	unsigned long height;
	unsigned long pitch;
	unsigned long unused;
	unsigned long *p_pix;
	void		  *reserved;
};

struct pi_BASICIMAGE
{
	unsigned long version;
	int (__cdecl* create)(pibi_IMAGE* img,int width,int height);
	int (__cdecl* virtualize)(pibi_IMAGE* img,int width,int height,
		int pitch,unsigned long* p_pix);
	int (__cdecl* destroy)(pibi_IMAGE* img);
//16
	int (__cdecl* lock)(pibi_IMAGE* img);
	int (__cdecl* unlock)(pibi_IMAGE* img);
//24
	HDC (__cdecl* gdi_getDC)(pibi_IMAGE* img);
	int (__cdecl* gdi_freeDC)(pibi_IMAGE* img,HDC hdc);
	HBITMAP (__cdecl* gdi_makeHBMP)(pibi_IMAGE* img);
	void* reserved_1;
//40
	int (__cdecl* blit)(
		pibi_IMAGE* dst,int dx0,int dy0,int dx1,int dy1,
		pibi_IMAGE* src,int sx0,int sy0,int sx1,int sy1,
		unsigned long options,unsigned long param);
	int (__cdecl* fill)(
		pibi_IMAGE* img,int x0,int y0,int x1,int y1,
		unsigned long color1,unsigned long color2,
		unsigned long color3,unsigned long color4,
		unsigned long options,int param1,int param2);
	int (__cdecl* blitToDC)(
		HDC hdc,int dx0,int dy0,int dx1,int dy1,
		pibi_IMAGE* src,int sx0,int sy0,int sx1,int sy1,
		unsigned long options,unsigned long param);
	void* reserved_2;
//56
	int (__cdecl* translate)(
		pibi_IMAGE* img,int x0,int y0,int x1,int y1,
		unsigned char *lut_r,unsigned char *lut_g,
		unsigned char *lut_b,unsigned char *lut_a,
		unsigned long options,void* param);
	int (__cdecl* transform)(
		pibi_IMAGE* img,int x0,int y0,int x1,int y1,
		double *matrix_5x4,unsigned long options);
	int (__cdecl* convolute)(
		pibi_IMAGE* dst,int x0,int y0,int x1,int y1,
		pibi_IMAGE* src,double *matrix,int mat_cols,int mat_rows,
		unsigned long mask,unsigned long options);
	int (__cdecl* compare)(pibi_IMAGE* img1,pibi_IMAGE* img2,RECT *rt_diff);
//72
	int (__cdecl* loadFile)(pibi_IMAGE* img,wchar_t* file);
	void* reserved_3;
//80
	unsigned char	reserved_x[1024-80];//do not touch
};

//flags for the "options" parameter of ::blit()
#define PI_BI_BLIT_BLOCKY						0x00000000
#define PI_BI_BLIT_STRETCH						0x00000001
#define PI_BI_BLIT_HQ_STRETCH					0x00000002
#define PI_BI_BLIT_ALPHABLEND					0x00000010
#define PI_BI_BLIT_RASTEROP  					0x00000020
#define PI_BI_BLIT_TILE_xxx						0x00030000
	#define PI_BI_BLIT_TILE_NORMAL				0x00010000
	#define PI_BI_BLIT_TILE_INVERT				0x00020000

//flags for the "options" parameter of ::fill()
//also used for "param" for blit::PI_BI_BLIT_RASTEROP
#define PI_BI_FILL_SHAPE_xxx					0x0000000f
	#define PI_BI_FILL_RECTANGLE				0x00000000
	#define PI_BI_FILL_ELLIPSE					0x00000001
	#define PI_BI_FILL_ROUNDRECT				0x00000002
#define PI_BI_FILL_ALPHABLEND					0x00000010
#define PI_BI_FILL_GRADIENT						0x00000020
#define PI_BI_FILL_RASTEROP_xxx					0x00ff0000
	#define PI_BI_FILL_RASTEROP_NONE            0x00000000
	#define PI_BI_FILL_RASTEROP_OR              0x00010000
	#define PI_BI_FILL_RASTEROP_AND             0x00020000
	#define PI_BI_FILL_RASTEROP_XOR             0x00030000
	#define PI_BI_FILL_RASTEROP_ADD             0x00040000
	#define PI_BI_FILL_RASTEROP_SUB             0x00050000
	#define PI_BI_FILL_RASTEROP_INC             0x00060000
	#define PI_BI_FILL_RASTEROP_DEC             0x00070000
	#define PI_BI_FILL_RASTEROP_MUL             0x00080000
	#define PI_BI_FILL_RASTEROP_OUT             0x00090000
	#define PI_BI_FILL_RASTEROP_OFF             0x000a0000
	#define PI_BI_FILL_RASTEROP_HUE             0x000b0000
	#define PI_BI_FILL_RASTEROP_CLR             0x000c0000
	#define PI_BI_FILL_RASTEROP_LUM             0x000d0000
	#define PI_BI_FILL_RASTEROP_SCRN            0x000e0000
	#define PI_BI_FILL_RASTEROP_MASK            0x000f0000
	#define PI_BI_FILL_RASTEROP_TEX             0x00100000
	#define PI_BI_FILL_RASTEROP_DIV             0x00110000
	#define PI_BI_FILL_RASTEROP_DIFF            0x00120000
	#define PI_BI_FILL_RASTEROP_MIN             0x00130000
	#define PI_BI_FILL_RASTEROP_MAX             0x00140000
	#define PI_BI_FILL_RASTEROP_SAT             0x00150000
	#define PI_BI_FILL_RASTEROP_OVER            0x00160000

//-----------------------------------------------------------------------------
//pi_BasicColor
//-----------------------------------------------------------------------------
#define PI_BASICCOLOR_VERSION					0x00010001

struct pi_BASICCOLOR
{
	unsigned long	version;
	int	(__cdecl*	convert)(unsigned long *colors,
		int count,int cp_in,int cp_out,unsigned long flags);
	unsigned long	reserved_1;//do not touch
	unsigned long	reserved_2;//do not touch
//16
	unsigned char	reserved_x[1024-16];//do not touch
};

//flags for "cp_in" and "cp_out" in ::convert()
#define PI_BC_COLORSPACE_RGB					0x00000000
#define PI_BC_COLORSPACE_BGR					0x00000001
#define PI_BC_COLORSPACE_YUV					0x00000002
#define PI_BC_COLORSPACE_CMY					0x00000003
#define PI_BC_COLORSPACE_CMYK					0x00000004
#define PI_BC_COLORSPACE_HSL					0x00000005
#define PI_BC_COLORSPACE_HSV					0x00000006
#define PI_BC_COLORSPACE_HHSL					0x00000007
#define PI_BC_COLORSPACE_HHSV					0x00000008

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////


/******************************************************************************
FastExternals Structs
******************************************************************************/

//-----------------------------------------------------------------------------
//plg_INFO
//-----------------------------------------------------------------------------
struct plg_INFO
{
	unsigned long	api_type;
	unsigned long	api_version;
	unsigned long	plugin_version;
	unsigned long	plugin_options;
//16
	wchar_t			plugin_name[64];
	wchar_t			plugin_author[64];
//272
	unsigned char	reserved_x[1024-272];//do not touch
};

//-----------------------------------------------------------------------------
//plg_DIALOG
//-----------------------------------------------------------------------------
struct plg_DIALOG
{
	HWND			hwnd;
	unsigned long	dialog;
	unsigned long	param_1;
	unsigned long	param_2;
//16
	unsigned char	reserved_1[256-16]; //do not touch
//256
	pi_STATESTORE*	pi_StateStore;
	pi_BASICQUERY*	pi_BasicQuery;
	pi_BASICIMAGE*	pi_BasicImage;
	pi_BASICCOLOR*	pi_BasicColor;
//272
	unsigned char	reserved_x[1024-272];//do not touch
};

//-----------------------------------------------------------------------------
//flt_IMAGE_L
//-----------------------------------------------------------------------------
struct flt_IMAGE_L
{
	unsigned long	width;
	unsigned long	height;
	unsigned long	pitch;
	unsigned long*	lp_pix;
//16
	wchar_t*		file;
	HWND			hwnd;
	int				(__cdecl* create)(flt_IMAGE_L* self);
	unsigned char	img_type;
	unsigned char	img_subtype;
	unsigned short	unused_1;
//32
	unsigned long	layer_count;
	short			x_pos;
	short			y_pos;
	wchar_t			name[32];
	unsigned short	options;
	unsigned short	frame_delay;
	unsigned char	group_id;
	unsigned char	transparency;
	unsigned char	unused_2[18];
//128
	unsigned char*	meta_data;
	int				(__cdecl* meta_write)(flt_IMAGE_L* self,char* type,int size);
//136
	unsigned char	reserved_1[256-136-(1+4+4)];//do not touch
	unsigned char	truncated;
	wchar_t*		error_hint;
	unsigned long	timeout;
//256
	pi_STATESTORE*	pi_StateStore;
	pi_BASICQUERY*	pi_BasicQuery;
	pi_BASICIMAGE*	pi_BasicImage;
	pi_BASICCOLOR*	pi_BasicColor;
//272
	unsigned char	reserved_x[1024-272];//do not touch
};

//-----------------------------------------------------------------------------
//flt_IMAGE_S
//-----------------------------------------------------------------------------
struct flt_IMAGE_S
{
	unsigned long	width;
	unsigned long	height;
	unsigned long	pitch;
	unsigned long*	lp_pix;
//16
	wchar_t*		file;
	HWND			hwnd;
	int				(__cdecl* next)(flt_IMAGE_S* self);
	unsigned char	img_type;
	unsigned char	img_subtype;
	unsigned short	unused_1;
//32
	unsigned long	layer_count;
	short			x_pos;
	short			y_pos;
	wchar_t			name[32];
	unsigned short	options;
	unsigned short	frame_delay;
	unsigned char	group_id;
	unsigned char	transparency;
	unsigned char	unused_2[18];
//128
	unsigned char*	meta_data;
	int				(__cdecl* meta_read)(flt_IMAGE_S* self,char* type);
//136
	unsigned char	reserved_1[256-136-(1+4+4)];//do not touch
	unsigned char	truncated;
	wchar_t*		error_hint;
	unsigned long	timeout;
//256
	pi_STATESTORE*	pi_StateStore;
	pi_BASICQUERY*	pi_BasicQuery;
	pi_BASICIMAGE*	pi_BasicImage;
	pi_BASICCOLOR*	pi_BasicColor;
//272
	unsigned char	reserved_x[1024-272];//do not touch
};

//-----------------------------------------------------------------------------
//flt_IMAGE_X
//-----------------------------------------------------------------------------
struct flt_IMAGE_X 
{
	wchar_t*		file;
	HWND			hwnd;
	unsigned long	xform_id;
	unsigned long	xform_id2;
//16
	unsigned char	reserved_1[256-16-(4+4)];//do not touch
	wchar_t*		error_hint;
	unsigned long	timeout;
//256
	pi_STATESTORE*	pi_StateStore;
	pi_BASICQUERY*	pi_BasicQuery;
	pi_BASICIMAGE*	pi_BasicImage;
	pi_BASICCOLOR*	pi_BasicColor;
//272
	unsigned char	reserved_x[1024-272];//do not touch
};

//-----------------------------------------------------------------------------
//dev_IMAGE_R
//-----------------------------------------------------------------------------
struct dev_IMAGE_R
{
	unsigned long	width;
	unsigned long	height;
	unsigned long	pitch;
	unsigned long*	lp_pix;
//16
	HWND			hwnd;
	unsigned long	unused_1;
	int				(__cdecl* create)(dev_IMAGE_R* self);
	unsigned char	img_type;
	unsigned char	img_subtype;
	unsigned short	unused_2;
//32
	unsigned long	layer_count;
	short			x_pos;
	short			y_pos;
	wchar_t			name[32];
	unsigned short	options;
	unsigned short	frame_delay;
	unsigned char	group_id;
	unsigned char	transparency;
	unsigned char	unused_3[18];
//128
	unsigned char*	meta_data;
	int				(__cdecl* meta_write)(dev_IMAGE_R* self,char* type,int size);
//136
	unsigned char	reserved_1[252-136];//do not touch
	unsigned long	timeout;
//256
	pi_STATESTORE*	pi_StateStore;
	pi_BASICQUERY*	pi_BasicQuery;
	pi_BASICIMAGE*	pi_BasicImage;
	pi_BASICCOLOR*	pi_BasicColor;
//272
	unsigned char	reserved_x[1024-272];//do not touch
};

//-----------------------------------------------------------------------------
//dev_IMAGE_S
//-----------------------------------------------------------------------------
struct dev_IMAGE_S
{
	unsigned long	width;
	unsigned long	height;
	unsigned long	pitch;
	unsigned long*	lp_pix;
//16
	HWND			hwnd;
	unsigned long	unused_1;
	int				(__cdecl* next)(dev_IMAGE_S* self);
	unsigned char	img_type;
	unsigned char	img_subtype;
	unsigned short	unused_2;
//32
	unsigned long	layer_count;
	short			x_pos;
	short			y_pos;
	wchar_t			name[32];
	unsigned short	options;
	unsigned short	frame_delay;
	unsigned char	group_id;
	unsigned char	transparency;
	unsigned char	unused_3[18];
//128
	unsigned char*	meta_data;
	int				(__cdecl* meta_read)(dev_IMAGE_S* self,char* type);
//136
	unsigned char	reserved_1[252-136];//do not touch
	unsigned long	timeout;
//256
	pi_STATESTORE*	pi_StateStore;
	pi_BASICQUERY*	pi_BasicQuery;
	pi_BASICIMAGE*	pi_BasicImage;
	pi_BASICCOLOR*	pi_BasicColor;
//272
	unsigned char	reserved_x[1024-272];//do not touch
};

//-----------------------------------------------------------------------------
//efx_IMAGE_T
//-----------------------------------------------------------------------------
struct efx_IMAGE_T
{
	unsigned long	width;
	unsigned long	height;
	unsigned long	pitch;
	unsigned long*	lp_pix;
//16
	HWND			hwnd;
	unsigned long	flags;
//24
	int				(__cdecl* lock   )(void);
	int				(__cdecl* unlock )(void);
	int				(__cdecl* load   )(void);
	int				(__cdecl* realloc)(void);
	int				(__cdecl* refresh)(void);
	int				(__cdecl* progress)(int done,int total);
//48
	unsigned long	color_1;
	unsigned long	color_2;
	unsigned long	unused_1;
	unsigned long	unused_2;
//64
	unsigned char*	(__cdecl* mem_alloc)(unsigned long size);
	unsigned char*	(__cdecl* mem_resize)(unsigned char* mem,unsigned long size);
	int				(__cdecl* mem_free)(unsigned char* mem);
	unsigned long	unused_3;
//80
	unsigned char*	meta_data;
	unsigned long	(__cdecl* meta_query)(char* type,unsigned long size);
//88
	int				(__cdecl* dock)(HWND hwnd);
	unsigned long	unused_4;
//96
	unsigned char	reserved_1[252-96];//do not touch
	unsigned long	unused_5;
//256
	pi_STATESTORE*	pi_StateStore;
	pi_BASICQUERY*	pi_BasicQuery;
	pi_BASICIMAGE*	pi_BasicImage;
	pi_BASICCOLOR*	pi_BasicColor;
//272
	unsigned char	reserved_x[1024-272];//do not touch
};

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////



/******************************************************************************
FastExternals Function Prototypes
******************************************************************************/

//support functions
typedef int (__cdecl* FUNC_FLT_CREATE)(void*);

//-----------------------------------------------------------------------------
//all plugins
typedef int (__cdecl* FUNC_PLG_INFO  )(struct plg_INFO*  );
typedef int (__cdecl* FUNC_PLG_DIALOG)(struct plg_DIALOG*);

//-----------------------------------------------------------------------------
//new filter layer (FastExternals)
typedef int (__cdecl* FUNC_FLT_LOADIMAGE)(struct flt_IMAGE_L*);
typedef int (__cdecl* FUNC_FLT_SAVEIMAGE)(struct flt_IMAGE_S*);
typedef int (__cdecl* FUNC_FLT_CHECKLOAD)(wchar_t*);
typedef int (__cdecl* FUNC_FLT_CHECKSAVE)(wchar_t*);
typedef int (__cdecl* FUNC_FLT_XFRMIMAGE)(struct flt_IMAGE_X*);

//-----------------------------------------------------------------------------
//new device layer (FastExternals)
typedef int (__cdecl* FUNC_DEV_READIMAGE)(struct dev_IMAGE_R*);
typedef int (__cdecl* FUNC_DEV_SENDIMAGE)(struct dev_IMAGE_S*);

//-----------------------------------------------------------------------------
//new effects layer (FastExternals)
typedef int (__cdecl* FUNC_EFX_DO_EFFECT)(struct efx_IMAGE_T*);

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
