/******************************************************************************
layerdef.h : layer options defines

Copyright John Paul Chacha. All Rights Reserved.

This source code file, which has been provided by John Paul Chacha as part of 
his software product for use only by licensed users of that product, includes 
proprietary information of John Paul Chacha.

USE OF THIS SOFTWARE IS GOVERNED BY THE TERMS AND CONDITIONS OF THE LICENSE 
AGREEMENT FURNISHED WITH THE PRODUCT.

IN PARTICULAR, JOHN PAUL CHACHA SHALL BE FREE FROM ANY CLAIMS OR LIABILITIES 
ARISING OUT OF THE USE OR MISUSE OF THIS FILE AND/OR ITS CONTENTS.
******************************************************************************/

#pragma once

//-----------------------------------------------------------------------------

//=============================================================================

#define LAYER_OPTION_xxx						0xff00
#define LAYER_OPTION_HIDDEN						0x0100
#define LAYER_OPTION_LOCKED						0x0200
#define LAYER_OPTION_EXCLUDED					0x0400
#define LAYER_OPTION_PROTECT					0x0800
#define LAYER_OPTION_CLICKTHRU					0x1000
#define LAYER_OPTION_FLOATING					0x2000

//-----------------------------------------------------------------------------

//=============================================================================

#define LAYER_BLEND_xxx							0x000000ff
#define LAYER_BLEND_NONE						0x000000ff
#define LAYER_BLEND_USER						0x000000fe
#define LAYER_BLEND_NORM						0x00000000
#define LAYER_BLEND_ADD							0x00000001
#define LAYER_BLEND_SUB							0x00000002
#define LAYER_BLEND_MUL							0x00000003
#define LAYER_BLEND_OFF							0x00000004
#define LAYER_BLEND_HUE 						0x00000005
#define LAYER_BLEND_CLR 						0x00000006
#define LAYER_BLEND_LUM 						0x00000007
#define LAYER_BLEND_SCRN						0x00000008
#define LAYER_BLEND_MASK						0x00000009
#define LAYER_BLEND_DIV 						0x0000000a
#define LAYER_BLEND_DIFF 						0x0000000b
#define LAYER_BLEND_MIN 						0x0000000c
#define LAYER_BLEND_MAX 						0x0000000d
#define LAYER_BLEND_SAT 						0x0000000e
#define LAYER_BLEND_OVER						0x0000000f
#define LAYER_BLEND_DODG						0x00000010
#define LAYER_BLEND_BURN						0x00000011

struct layerdef_names_tag
{
	int id;
	wchar_t* name;
};

const layerdef_names_tag 
	layerdef_blendmode_names[]=
{
	LAYER_BLEND_NORM, L"Normal",
	LAYER_BLEND_NONE, L"None",
	LAYER_BLEND_MASK, L"Mask",

	LAYER_BLEND_ADD , L"Add",
	LAYER_BLEND_SUB , L"Subtract",
	LAYER_BLEND_MUL , L"Multiply",
	LAYER_BLEND_DIV , L"Divide",

	LAYER_BLEND_OFF , L"Offset",
	LAYER_BLEND_MIN , L"Minimum",
	LAYER_BLEND_MAX , L"Maximum",
	LAYER_BLEND_DIFF, L"Difference",

	LAYER_BLEND_SCRN, L"Screen",
	LAYER_BLEND_OVER, L"Overlay",
	LAYER_BLEND_DODG, L"Dodge",
	LAYER_BLEND_BURN, L"Burn",

	LAYER_BLEND_LUM , L"Luma",
	LAYER_BLEND_CLR , L"Chroma",
	LAYER_BLEND_HUE , L"Hue",
	LAYER_BLEND_SAT , L"Saturation",

	LAYER_BLEND_USER, L"Custom",

	0,0,
	0,0
};

//-----------------------------------------------------------------------------

//=============================================================================