/******************************************************************************
metadef.h : metadata defines

Copyright John Paul Chacha. All Rights Reserved.

This source code file, which has been provided by John Paul Chacha as part of
his software product for use only by licensed users of that product, includes
proprietary information of John Paul Chacha.

USE OF THIS SOFTWARE IS GOVERNED BY THE TERMS AND CONDITIONS OF THE LICENSE
AGREEMENT FURNISHED WITH THE PRODUCT.

IN PARTICULAR, JOHN PAUL CHACHA SHALL BE FREE FROM ANY CLAIMS OR LIABILITIES
ARISING OUT OF THE USE OR MISUSE OF THIS FILE AND/OR ITS CONTENTS.
******************************************************************************/

#pragma once

//=============================================================================
//Globals
//-----------------------------------------------------------------------------

#define MAX_META_COUNT			16

#ifndef META_ID_CREATE
	#define META_ID_CREATE(a,b,c,d) \
		((((unsigned long)a)    )| \
		( ((unsigned long)b)<< 8)| \
		( ((unsigned long)c)<<16)| \
		( ((unsigned long)d)<<24))
	#define META_ID_META		META_ID_CREATE('M','E','T','A')
	#define META_ID_TEXT		META_ID_CREATE('T','E','X','T')
	#define META_ID_PATH		META_ID_CREATE('P','A','T','H')
	#define META_ID_TILE		META_ID_CREATE('T','I','L','E')
	#define META_ID_MARK		META_ID_CREATE('M','A','R','K')
	#define META_ID_NOTE		META_ID_CREATE('N','O','T','E')
	#define META_ID_APPL		META_ID_CREATE('A','P','P','L')
	#define META_ID_EXIF		META_ID_CREATE('E','X','I','F')
	#define META_ID_BLND		META_ID_CREATE('B','L','N','D')
#endif

//=============================================================================
//meta META
//-----------------------------------------------------------------------------

#pragma pack(push)
#pragma pack(1)
	struct meta_tag_META
	{
		unsigned long		tag_id;
		unsigned long		version;
		unsigned long		unused_1;
		unsigned long		size;
	};
#pragma pack(pop)

//=============================================================================
//meta TILE
//-----------------------------------------------------------------------------

#pragma pack(push)
#pragma pack(1)
	struct meta_tag_TILE
	{
		unsigned long		uuid;
		char				purpose[20];
		char				unused_1[256-(20+4)];
	};
#pragma pack(pop)

//=============================================================================
//meta PATH
//-----------------------------------------------------------------------------

#define META_PATH_FLAG_END  	0x01
#define META_PATH_FLAG_CLOSE	0x02

#pragma pack(push)
#pragma pack(1)
	struct meta_tag_PATH_pt
	{
		long			x;//x coordinate
		long			y;//y coordinate
		unsigned char	z;//z or tightness indicator
		unsigned char	flags;//signalling parameter
	};
	struct meta_tag_PATH_hdr
	{
		unsigned short		version;//path version
		unsigned short		count;//point count
		unsigned long		flags;//flags
		unsigned long		unused_1;//unused
		unsigned long		unused_2;//unused
		meta_tag_PATH_pt	entries[1];
	};
#pragma pack(pop)

//=============================================================================
//meta APPL
//-----------------------------------------------------------------------------

#pragma pack(push)
#pragma pack(1)
	struct meta_tag_APPL
	{
		wchar_t			name[32];
		wchar_t			file[32];
		char			unused_1[256-128];
	};
#pragma pack(pop)

//=============================================================================
//meta BLND
//-----------------------------------------------------------------------------

#define META_BLND_TYPE_LUT	0x00

#pragma pack(push)
#pragma pack(1)
	struct meta_tag_BLND
	{
		unsigned char	type;
		unsigned char	mode;
		unsigned short	span;
		unsigned long	flags;
		wchar_t			name[32];
	};
#pragma pack(pop)

//=============================================================================