#!/bin/sh
# Install some preneeded packages for WINE@Etersoft.
# See in redist.html for additional information.
# You have no permission to publish the content of this file

# Note: remove placeholders before native dlls installing!

STEPPROGRESS=6
[ -r ${WINECONFDIR}/script.d/odbcinstall.sh ] && STEPPROGRESS=4

SYSDIR="$CROOT/windows/system32"
DOWNLOADS="$CROOT/windows/downloads"

ls_icase()
{
	find $1 -iname "$2" 2>/dev/null
}

# Remove listed dlls
predel()
{
	for i in $@ ; do
		rm -fv $(ls_icase $SYSDIR "$i")
	done >>$WINEPREFIX/install.log 2>>$WINEPREFIX/install.log
}

failed()
{
	echo "$@      [ ERROR ]"
	[ "$FORCE" = "y" ] || exit 1
}

try_reg()
{
	if [ -e $SYSDIR/$1 ] ; then
		( cd $SYSDIR ; $WINELOADER regsvr32.exe $1 ; )
	fi
}

# test file twice due some racing
test_file()
{
	test -f "$SYSDIR/$1" && return
	sleep 1
	test -f "$SYSDIR/$1" || failed "Checking $SYSDIR/$1: "
}

# Remove obsoleted files
cleanup_dll()
{
	predel wbemprox.dll
}

install_dll()
{
TOINSTALL=$DOWNLOADS/vcredist.exe
if [ -e $TOINSTALL ] ; then
        predel msvcrt.dll stdole2.tlb oleaut32.dll olepro32.dll asycfilt.dll comcat.dll msvcp60.dll mfc42.dll
        echo "VC6 redistributable components installing..." | tee -a $WINEPREFIX/install.log
        # vcredist still exits with status 43.  Anyone know why?
        WINDOWS_VERSION=winxp $WINELOADER $TOINSTALL /Q:A 2>>$WINEPREFIX/install.log || true
        test_file msvcrt.dll
        test_file mfc42.dll
        # TODO: unpack mfc32u from vcredist (/Q /C /T:path - extract all files), now distribute it in wine-school-components
        # See http://support.microsoft.com/kb/259403/ru
        # vcredist removed mfc42u.dll
        #cp -f ${WINEDATADIR}/skel/windows/system32/mfc42u.dll $SYSDIR/mfc42u.dll
        test_file mfc42u.dll
        test_file msvcrt.dll
fi

TOINSTALL=$DOWNLOADS/vcredist_x86-2005.exe
if [ -e $TOINSTALL ] ; then
        predel mfc80.dll
        echo "VC2005 redistributable components installing..." | tee -a $WINEPREFIX/install.log
        WINDOWS_VERSION=win98 $WINELOADER $TOINSTALL /Q:A 2>>$WINEPREFIX/install.log
        test -f $SYSDIR/mfc80.dll || failed
fi

step_progress

TOINSTALL=$DOWNLOADS/InstMsiA.exe
if [ -e $TOINSTALL ] ; then
	predel msi.dll msiexec.exe riched20.dll msihnd.dll msimsg.dll msisip.dll
	echo "MSI installing..." | tee -a $WINEPREFIX/install.log
	WINDOWS_VERSION="win95" WINEDLLOVERRIDES="riched20,msi,msiexec.exe=n" $WINELOADER $TOINSTALL /r:n /q:a 2>>$WINEPREFIX/install.log
	test_file msiexec.exe
	rm -rf $CROOT/windows/Installer
	rm -rf $CROOT/users/$USER/Temp/msievent.log
fi

TOINSTALL=$DOWNLOADS/7z.msi
if [ -e $TOINSTALL ] ; then
        echo "7-Zip installing..." | tee -a $WINEPREFIX/install.log
        $WINELOADER msiexec /i $TOINSTALL /q 2>>$WINEPREFIX/install.log
fi

TOINSTALL=$DOWNLOADS/Far.msi
if [ -e $TOINSTALL ] ; then
        echo "FAR installing..." | tee -a $WINEPREFIX/install.log
        $WINELOADER msiexec /i $TOINSTALL /q 2>>$WINEPREFIX/install.log
fi

TOINSTALL=$DOWNLOADS/msxml3.msi
if [ -e $TOINSTALL ] ; then
        predel msxml3.dll msxml3a.dll msxml3r.dll
        echo "MS XML Core Services 3.0 installing..." | tee -a $WINEPREFIX/install.log
        # FIXME: broken MSI in wine
        #$WINELOADER msiexec /i $TOINSTALL /q 2>>$WINEPREFIX/install.log
        # Just extract with 7-zip
        cd $SYSDIR
        $WINELOADER "C:\\Program Files\\7-Zip\\7z.exe" x -y $TOINSTALL >>$WINEPREFIX/install.log 2>&1
        rm -f mdacmsxmlx.inf.A2CDD4E1_ADB3_473C_BD47_FE5024412C07
        mv msxml3a.dll.C8C0673E_50E5_4AC4_817B_C0E4C4466990 msxml3a.dll
        mv msxml3.dll.C8C0673E_50E5_4AC4_817B_C0E4C4466990 msxml3.dll
        mv msxml3r.dll.C8C0673E_50E5_4AC4_817B_C0E4C4466990 msxml3r.dll
        rm -f msxmlx.cat.A2CDD4E1_ADB3_473C_BD47_FE5024412C07
        rm -f msxmlx.inf.A2CDD4E1_ADB3_473C_BD47_FE5024412C07
        cd -
        test_file msxml3.dll
fi


TOINSTALL=$DOWNLOADS/msxml4.msi
if [ -e $TOINSTALL ] ; then
        predel msxml4.dll msxml4r.dll
        echo "MS XML Core Services 4.0 installing..." | tee -a $WINEPREFIX/install.log
        # FIXME: broken MSI in wine
        #$WINELOADER msiexec /i $TOINSTALL /q 2>>$WINEPREFIX/install.log
        # Just extract with 7-zip
        cd $SYSDIR
        $WINELOADER "C:\\Program Files\\7-Zip\\7z.exe" x -y $TOINSTALL >>$WINEPREFIX/install.log 2>&1
        rm -f catalog.7277524D_AF9E_03D8_FF6B_D6B9ABF34537
        rm -f catalog.74974F83_779E_3983_FF6B_D6B9ABF34537
        rm -f manifest.7277524D_AF9E_03D8_FF6B_D6B9ABF34537
        rm -f manifest.74974F83_779E_3983_FF6B_D6B9ABF34537
        mv msxml4.dll.246EB7AD_459A_4FA8_83D1_41A46D7634B7 msxml4.dll
        mv msxml4r.dll.246EB7AD_459A_4FA8_83D1_41A46D7634B7 msxml4r.dll
        rm -f msxml4.dll.74974F83_779E_3983_FF6B_D6B9ABF34537
        rm -f msxml4r.dll.7277524D_AF9E_03D8_FF6B_D6B9ABF34537
        rm -f ul_catalog.7277524D_AF9E_03D8_FF6B_D6B9ABF34537
        rm -f ul_catalog.74974F83_779E_3983_FF6B_D6B9ABF34537
        rm -f ul_manifest.7277524D_AF9E_03D8_FF6B_D6B9ABF34537
        rm -f ul_manifest.74974F83_779E_3983_FF6B_D6B9ABF34537
        rm -f ul_msxml4.dll.74974F83_779E_3983_FF6B_D6B9ABF34537
        rm -f ul_msxml4r.dll.7277524D_AF9E_03D8_FF6B_D6B9ABF34537
        cd -
        test_file msxml4.dll
fi




step_progress

TOINSTALL=$DOWNLOADS/WindowsXP-Windows2000-Script56-KB917344-x86-enu.exe
if [ -e $TOINSTALL ] ; then
	predel wscript.exe WSCRIPT.EXE jscript.dll vbscript.dll scrrun.dll dispex.dll scrobj.dll wshom.ocx wshext.dll cscript.exe
	echo "Windows Scripting installing..." | tee -a $WINEPREFIX/install.log

	WINDOWS_VERSION=win98 $WINELOADER $TOINSTALL /Q:A
	test_file wscript.exe
fi
step_progress

TOINSTALL=$DOWNLOADS/sct10en.exe
if [ -e $TOINSTALL ] ; then
	predel msscript.ocx
	echo "Script Control installing..." | tee -a $WINEPREFIX/install.log

	WINDOWS_VERSION=win98 $WINELOADER $TOINSTALL /Q:A
	test_file msscript.ocx
	step_progress
fi

}

# Run install DLLs only if has admin permissions (write to C: drive)
if [ -w "$CROOT" ] && [ "$WINEMODE" != "--attach" ] ; then
	cleanup_dll
	install_dll
else
	echo "Skip dlls installing (just attaching...)" | tee -a $WINEPREFIX/install.log
fi

# Register DLLs
WINDOWS_VERSION="win98" try_reg msxml3.dll
WINDOWS_VERSION="win98" try_reg msxml4.dll
WINDOWS_VERSION="win98" try_reg mfc40.dll
try_reg mfc42.dll
# fix eterbug #3163
try_reg msscript.ocx
WINDOWS_VERSION=winxp try_reg mfc42u.dll

# Disable root fs displaying from Desktop (eterbug #1501)
$WINELOADER regedit /D "HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Desktop\\Namespace\\{9D20AAE8-0625-44B0-9CA7-71889C2254D9}"


