# IEs 4 Linux
# Developed by: Sergio Luis Lopes Junior <slopes at gmail dot com>
# Project site: http://tatanka.com.br/ies4linux
# Released under the GNU GPL. See LICENSE for more information
# install.sh Perform all three ies installations

[ "$INSTALLIE6"   = "1" ] &&  {
	section $MSG_INSTALLING IE 6
	
	subsection $MSG_INITIALIZING
		DIR="$DOWNLOADDIR/ie6/$IE6_LOCALE"
                set_wine_prefix "$WINEPREFIX"

		wine >/dev/null 2>/dev/null || {
			wine
			error $MSG_ERROR_NO_WINEPREFIXCREATE
		}
	
		# Discover Wine folders
		DRIVEC=dosdevices/c:
		WINDOWS=windows
		SYSTEM32=system32
		FONTS=Fonts
		INF=inf
		if [ -d "$BASEDIR/dosdevices/c:" ]; then DRIVEC=dosdevices/c: ; fi
		if [ -d "$BASEDIR/$DRIVEC/windows" ]; then WINDOWS=windows; fi
		if [ -d "$BASEDIR/$DRIVEC/$WINDOWS/system32" ]; then SYSTEM32=system32; fi
		if [ -d "$BASEDIR/$DRIVEC/$WINDOWS/fonts" ]; then FONTS=fonts; fi
		if [ -d "$BASEDIR/$DRIVEC/$WINDOWS/Fonts" ]; then FONTS=Fonts; fi
		if [ -d "$BASEDIR/$DRIVEC/$WINDOWS/inf" ]; then INF=inf;fi

		SYSDIR="$BASEDIR/$DRIVEC/$WINDOWS/$SYSTEM32"

		WINDIR=`winepath -w $DIR 2>/dev/null`
		WINDOWNLOADDIR=`winepath -w $DOWNLOADDIR 2>/dev/null`

	subsection $MSG_EXTRACTING_CABS
		echo -n " "
                cd "$WORKDIR/tmp"
#		echo "Install $SCR56"
		CABS="ADVAUTH.CAB CRLUPD.CAB HHUPD.CAB IEDOM.CAB IE_S1.CAB IE_S2.CAB IE_S3.CAB \
			IE_S4.CAB IE_S5.CAB IE_S6.CAB $SCR56.CAB SETUPW95.CAB VGX.CAB" 
		for cab in $CABS; do
		    extrac32cab "$WINDIR\\$cab"
		echo -n "."
		done
		tolowercase
		for i in ie*cab; do
		    extrac32cab $i
		    echo -n "."
		done
		echo
		tolowercase
		rm -f *cab regsvr32.exe setup*
	subsection $MSG_PROCESSING_INF
		echo -n " "
		for i in *.inf; do
			run_inf $i
			echo -n "."
		done
		echo
		rm *hlp

	subsection $MSG_INSTALLING IE 6
		mv -f *.inf "$BASEDIR/$DRIVEC/$WINDOWS/$INF/"
		mv -f cscript.exe "$BASEDIR/$DRIVEC/$WINDOWS/$COMMAND/"
		mv -f wscript.exe "$BASEDIR/$DRIVEC/$WINDOWS/"
		
		mv -f sch128c.dll  "$SYSDIR/schannel.dll"
		IEDIR="$BASEDIR/$DRIVEC/Program Files/Internet Explorer"
		mkdir -p "$IEDIR"
		mv -f iexplore.exe "$IEDIR/iexplore.exe"
		chmod a+x "$IEDIR/iexplore.exe"
		
		mkdir -p "$SYSDIR/sfp/ie/"
		mv -f vgx.cat "$SYSDIR/sfp/ie/"
		mv -f * "$SYSDIR/"
	
	subsection $MSG_INSTALLING_FONTS
		for i in `echo $DIR/FONT*.CAB` ; do
		    BN=`basename $i`
    		    extrac32cab "$WINDIR\\$BN *.TTF"
		done
		tolowercase
		mv *ttf "$BASEDIR/$DRIVEC/$WINDOWS/$FONTS/"

        [ ! -f "$BASEDIR/.etersoft-release" ] && {
        subsection $MSG_INSTALLING RICHED20
                #$CABEXTRACT -L -F ver1200.exe "$DIR/249973USA8.exe" >/dev/null 2>/dev/null
                extractEXEcab $WINDIR\\249973USA8.exe "$(pwd)"
                #$CABEXTRACT -L "ver1200.exe" >/dev/null 2>/dev/null
                extractEXEcab ver1200.exe "$(pwd)"
                rm -f "$SYSDIR/riched20.dll"
                rm -f "$SYSDIR/riched32.dll"
                run_inf 1200up.inf
                mv *.inf "$BASEDIR/$DRIVEC/$WINDOWS/$INF/"
                rm -f *
        }

	subsection $MSG_INSTALLING_REGISTRY
#		del_registry_key HKEY_USERS\\S-1-5-4\\Software\\Wine\\AppDefaults\\iexplore.exe\\DllOverrides
#		del_registry_key HKEY_USERS\\S-1-5-4\\Software\\Wine\\DllOverrides
		add_registry "$IES4LINUX"/winereg/iedlls.reg
		add_registry "$IES4LINUX"/winereg/ie6.reg
		add_registry "$IES4LINUX"/winereg/homepage.reg

        [ ! -f "$BASEDIR/.etersoft-release" ] && {
        subsection $MSG_INSTALLING DCOM98
                #$CABEXTRACT -L -d "$BASEDIR/$DRIVEC/$WINDOWS/$SYSTEM/" "$DIR/DCOM98.EXE" >/dev/null 2>/dev/null
                extractEXEcab "$WINDIR/DCOM98.EXE" "$SYSDIR"
                run_inf dcom98.inf
                rm -f *
        }

	subsection $MSG_FINALIZING
		wineboot
#		touch "$BASEDIR/ie6/.firstrun"
		touch "$BINDIR/ie6/.firstrun"
		createShortcuts ie6 6.0
#		chmod -R u+rwx "$BASEDIR/ie6"
		chmod -R u+rwx "$BINDIR/ie6"
#		clean_tmp
	
	ok
}

. "$IES4LINUX/lib/flash.sh"
