if (NOT VERBOSE)
	set(ffmpegExtractOutput OUTPUT_VARIABLE FFMPEG_EXTRACT_OUTPUT)
endif (NOT VERBOSE)

#set(FFMPEG_SOURCE_ARCHIVE "ffmpeg_r${FFMPEG_VERSION}.tar.gz")
#set(SWSCALE_SOURCE_ARCHIVE "libswscale_r${SWSCALE_VERSION}.tar.gz")

if (EXISTS "${LIBRARY_SOURCE_DIR}/${FFMPEG_SOURCE_ARCHIVE}") # AND EXISTS "${LIBRARY_SOURCE_DIR}/${SWSCALE_SOURCE_ARCHIVE}")
	if (NOT EXISTS "${FFMPEG_SOURCE_DIR}/ffmpeg.c" OR NOT ${LAST_FFMPEG_VERSION} EQUAL ${FFMPEG_VERSION})
		find_package(Tar)

		execute_process(COMMAND ${CMAKE_COMMAND} -E remove_directory "ffmpeg"
					WORKING_DIRECTORY "${LIBRARY_SOURCE_DIR}")

		execute_process(COMMAND ${TAR_EXECUTABLE} xvf ${FFMPEG_SOURCE_ARCHIVE}
					WORKING_DIRECTORY "${LIBRARY_SOURCE_DIR}"
					${ffmpegExtractOutput})

		execute_process(COMMAND ${CMAKE_COMMAND} -E rename "ffmpeg-0.7-rc1" "ffmpeg"
					WORKING_DIRECTORY "${LIBRARY_SOURCE_DIR}")

		set(FFMPEG_PERFORM_PATCH 1)
		set(FFMPEG_PERFORM_BUILD 1)
	endif (NOT EXISTS "${FFMPEG_SOURCE_DIR}/ffmpeg.c" OR NOT ${LAST_FFMPEG_VERSION} EQUAL ${FFMPEG_VERSION})

	#if (NOT EXISTS "${FFMPEG_SOURCE_DIR}/libswscale/swscale.c" OR NOT ${LAST_SWSCALE_VERSION} EQUAL ${SWSCALE_VERSION})
		#find_package(Tar)

		#execute_process(COMMAND ${TAR_EXECUTABLE} xvf ../${SWSCALE_SOURCE_ARCHIVE}
					#WORKING_DIRECTORY "${FFMPEG_SOURCE_DIR}"
					#${ffmpegExtractOutput})

		#set(FFMPEG_PERFORM_PATCH 1)
		#set(FFMPEG_PERFORM_BUILD 1)
	#endif (NOT EXISTS "${FFMPEG_SOURCE_DIR}/libswscale/swscale.c" OR NOT ${LAST_SWSCALE_VERSION} EQUAL ${SWSCALE_VERSION})

	set(FFMPEG_PREPARED 1)
	set(LAST_FFMPEG_VERSION "${FFMPEG_VERSION}" CACHE STRING "" FORCE)
	#set(LAST_SWSCALE_VERSION "${SWSCALE_VERSION}" CACHE STRING "" FORCE)
endif (EXISTS "${LIBRARY_SOURCE_DIR}/${FFMPEG_SOURCE_ARCHIVE}") # AND EXISTS "${LIBRARY_SOURCE_DIR}/${SWSCALE_SOURCE_ARCHIVE}")