#ifndef APPCONTROLLER_H
#define APPCONTROLLER_H

#include <QString>
#include <QList>
#include <QStringList>
#include <QSettings>
#include <QSqlDatabase>
#include <QNetworkConfigurationManager>
#include <QNetworkSession>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkCookieJar>
#include <QTimer>
#include <QWidget>
#include <QRadioButton>
#include <QListWidgetItem>

#include <downloadmanager.h>

namespace Ui
{
    class AppController;
}

class YTNetworkCookieJar : public QNetworkCookieJar
{
    Q_OBJECT

public:
    explicit YTNetworkCookieJar(QObject *parent = 0);
    virtual ~YTNetworkCookieJar();

private:
    QSqlDatabase CookieDatabase;
};

class AppController : public QWidget
{
    Q_OBJECT

public:
    explicit AppController(QWidget *parent = 0);
    virtual ~AppController();

private slots:
    void InitNetwork();
    void NetworkSessionOpened();
    void NetworkSessionClosed();
    void NetworkSessionError(QNetworkSession::SessionError);

    void UpdateDownloadsList();

    void NetworkRequestFinished(QNetworkReply *reply);

    void on_WebView_loadStarted();
    void on_WebView_loadFinished(bool);

    void on_NavigateButton_toggled(bool);
    void on_DownloadButton_clicked();
    void on_DownloadsButton_clicked();
    void on_BrowsePageExitButton_clicked();

    void on_BackStopButton_clicked();
    void on_ReloadButton_clicked();
    void on_PreviewButton_clicked();
    void on_HelpButton_clicked();

    void on_DownloadOKButton_clicked();
    void on_DownloadCancelButton_clicked();

    void on_DeleteDownloadButton_clicked();
    void on_PlayPauseButton_clicked();
    void on_BrowseButton_clicked();
    void on_DownloadsPageExitButton_clicked();

    void on_DownloadsListWidget_currentRowChanged(int);
    void on_DownloadsListWidget_itemDoubleClicked(QListWidgetItem* item);

private:
    class VideoFormat {
    public:
        int     Fmt;
        QString Name;
        QString Extension;
    };

    void NetworkStateChanged(bool is_online);
    void AdjustWidgets();

    QString MakeValidFilename(const QString &string);
    QString MakeHumanReadableSize(qlonglong bytes);

    static const int BROWSE_PAGE    = 0,
                     DOWNLOAD_PAGE  = 1,
                     DOWNLOADS_PAGE = 2;

    static const int UPDATE_INTERVAL          = 1000,
                     MAX_FNAME_DUPCHECK_TRIES = 100;

    Ui::AppController *ui;

    bool                                 NetworkInitialization, WebViewInitialized, WebViewLoading, MetadataLoading, PreviewLoading;
    QString                              VideoId, VideoTitle;
    QList<VideoFormat>                   AllVideoFormats, AvailableVideoFormats;
    QStringList                          AvailableDisks;
    QList<QRadioButton*>                 VideoFormatRadioButtons;
    QList<DownloadManager::DownloadTask> DownloadTasks;
    QTimer                               DownloadsListUpdateTimer;
    QNetworkConfigurationManager         *NetworkConfigurationManager;
    QNetworkSession                      *NetworkSession;
    QNetworkAccessManager                *NetworkAccessManager;
    QSettings                            *AppSettings;
    DownloadManager                      *DownloadMgr;
    QNetworkReply                        *MetadataReply, *PreviewReply;
};

#endif // APPCONTROLLER_H
