#ifndef DOWNLOADSCONTROLLER_H
#define DOWNLOADSCONTROLLER_H

#include <QObject>
#include <QString>
#include <QList>
#include <QIODevice>
#include <QFile>
#include <QDir>
#include <QNetworkReply>
#include <QNetworkAccessManager>

class DownloadManager : public QObject
{
    Q_OBJECT

public:
    enum DOWNLOAD_TASK_STATES {STATE_ACTIVE, STATE_COMPLETED, STATE_ERROR, STATE_QUEUED, STATE_PAUSED};

    class DownloadTask {
    public:
        int     State, Fmt;
        qint64  Size, Done;
        QString FileName, VideoId, FileExtension, DestinationDisk, Title, ErrorMsg;
    };

    explicit DownloadManager(QNetworkAccessManager *network_access_manager, QObject *parent = 0);
    virtual ~DownloadManager();

    void SetNetworkAvailability(bool network_available);

    const QList<DownloadTask> &GetTasks();

    bool AddTask(const QString &file_name, const QString &video_id, int fmt, const QString &file_extension, const QString &destination_disk, const QString &title, QString *validate_result);
    void DelTask(const QString &file_name);
    void PauseTask(const QString &file_name);
    void ResumeTask(const QString &file_name);

    bool    HaveDuplicate(const QString &file_name);
    QString MakeFullFilenameForTask(const DownloadTask &task);

    bool ParseMetadata(const QByteArray &raw_data, QString *video_title, QHash<int, QString> *fmt_url_map);

private slots:
    void RunQueue();

    void NetworkRequestFinished(QNetworkReply *reply);

    void DownloadProgress(qint64 received, qint64 total);
    void DownloadDataReady();

private:
    bool ReopenCurrentFile(bool *file_valid);

    void UpdateTask(const DownloadTask &task);

    bool LoadTask(const QString &file_name, DownloadTask *task);
    void SaveTask(const DownloadTask &task);
    void ClearTask(const DownloadTask &task);

    QString ConvertHTMLEntities(const QString &string);
    QString FormatNetworkError(QNetworkReply::NetworkError error);

    static const int QUEUE_RUN_AFTER = 1000;

    bool                  NetworkAvailable;
    QDir                  DownloadsDir;
    QList<DownloadTask>   DownloadTasks;
    DownloadTask          CurrentTask;
    QFile                 CurrentFile;
    QNetworkAccessManager *NetworkAccessManager;
    QNetworkReply         *MetadataReply, *DownloadReply;
};

#endif // DOWNLOADSCONTROLLER_H
